implementation module controlcreate


//	Clean Object I/O library, version 1.1

//	Control creation.


import	StdBool, StdInt, StdList, StdMisc
import	oswindow
import	commondef, controldefaccess, controlvalidate, windowaccess
from	StdPSt	import PSt, IOSt


/*	createControls generates the proper system resources for all given WElementHandles of the window.
*/
createControls :: !(Maybe Id) !Bool !OSWindowPtr ![WElementHandle .ls .ps] !*OSToolbox
											 -> (![WElementHandle .ls .ps],!*OSToolbox)
createControls defaultId ableContext wPtr itemHs tb
	= StateMap (createWElementHandle defaultId True ableContext zero wPtr) itemHs tb

/*	createCompoundControls generates the proper system resources for those controls that are part of the 
	CompoundControl with the given Id, skipping its first nr of controls given by the Int argument.
	The WElementHandles must be the complete list of controls of the window.
*/
createCompoundControls :: !Id !Int !(Maybe Id) !Bool !OSWindowPtr ![WElementHandle .ls .ps] !*OSToolbox
															  -> (![WElementHandle .ls .ps],!*OSToolbox)
createCompoundControls compoundId nrSkip defaultId ableContext wPtr itemHs tb
	= StateMap (createCompoundWElementHandle compoundId nrSkip defaultId True ableContext zero wPtr) itemHs tb
where
	createCompoundWElementHandle :: !Id !Int !(Maybe Id) !Bool !Bool !Point !OSWindowPtr !(WElementHandle .ls .ps) !*OSToolbox
																					  -> (!WElementHandle .ls .ps, !*OSToolbox)
	createCompoundWElementHandle compoundId nrSkip defaultId showContext ableContext parentPos wPtr (WListLSHandle itemHs) tb
		# (itemHs,tb)	= StateMap (createCompoundWElementHandle compoundId nrSkip defaultId showContext ableContext parentPos wPtr) itemHs tb
		= (WListLSHandle itemHs,tb)
	createCompoundWElementHandle compoundId nrSkip defaultId showContext ableContext parentPos wPtr (WExtendLSHandle wExH=:{wExtendItems=itemHs}) tb
		# (itemHs,tb)	= StateMap (createCompoundWElementHandle compoundId nrSkip defaultId showContext ableContext parentPos wPtr) itemHs tb
		= (WExtendLSHandle {wExH & wExtendItems=itemHs},tb)
	createCompoundWElementHandle compoundId nrSkip defaultId showContext ableContext parentPos wPtr (WChangeLSHandle wChH=:{wChangeItems=itemHs}) tb
		# (itemHs,tb)	= StateMap (createCompoundWElementHandle compoundId nrSkip defaultId showContext ableContext parentPos wPtr) itemHs tb
		= (WChangeLSHandle {wChH & wChangeItems=itemHs},tb)
	createCompoundWElementHandle compoundId nrSkip defaultId showContext ableContext parentPos wPtr (WItemHandle itemH=:{wItemKind,wItemId}) tb
		| wItemKind<>IsCompoundControl
			= (WItemHandle itemH,tb)
		| not (identifyMaybeId compoundId wItemId)
			# (itemHs,tb)		= StateMap (createCompoundWElementHandle compoundId nrSkip defaultId showContext1 ableContext1 itemPos itemPtr) itemH.wItems tb
			= (WItemHandle {itemH & wItems=itemHs},tb)
		// otherwise
		# (oldItems,newItems)	= Split nrSkip itemH.wItems
		# (newItems,tb)			= StateMap (createWElementHandle defaultId showContext1 ableContext1 itemPos itemPtr) newItems tb
		# tb					= OSinvalidateCompound itemPtr tb		// PA: added
		= (WItemHandle {itemH & wItems=oldItems++newItems},tb)
	where
		showContext1			= showContext && itemH.wItemShow
		ableContext1			= ableContext && itemH.wItemSelect
		itemPos					= itemH.wItemPos
		itemPtr					= itemH.wItemPtr


/*	createWElementHandle generates the proper system resources.
*/
createWElementHandle :: !(Maybe Id) !Bool !Bool !Point !OSWindowPtr !(WElementHandle .ls .ps) !*OSToolbox
																 -> (!WElementHandle .ls .ps, !*OSToolbox)
createWElementHandle defaultId showContext ableContext parentPos wPtr (WListLSHandle itemHs) tb
	# (itemHs,tb)	= StateMap (createWElementHandle defaultId showContext ableContext parentPos wPtr) itemHs tb
	= (WListLSHandle itemHs,tb)
createWElementHandle defaultId showContext ableContext parentPos wPtr (WExtendLSHandle wExH=:{wExtendItems=itemHs}) tb
	# (itemHs,tb)	= StateMap (createWElementHandle defaultId showContext ableContext parentPos wPtr) itemHs tb
	= (WExtendLSHandle {wExH & wExtendItems=itemHs},tb)
createWElementHandle defaultId showContext ableContext parentPos wPtr (WChangeLSHandle wChH=:{wChangeItems=itemHs}) tb
	# (itemHs,tb)	= StateMap (createWElementHandle defaultId showContext ableContext parentPos wPtr) itemHs tb
	= (WChangeLSHandle {wChH & wChangeItems=itemHs},tb)
createWElementHandle defaultId showContext ableContext parentPos wPtr (WItemHandle itemH) tb
	# (itemH,tb)	= createWItemHandle defaultId showContext ableContext parentPos wPtr itemH tb
	= (WItemHandle itemH,tb)
where
	createWItemHandle :: !(Maybe Id) !Bool !Bool !Point !OSWindowPtr !(WItemHandle .ls .ps) !*OSToolbox
																  -> (!WItemHandle .ls .ps, !*OSToolbox)
	
	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsRadioControl} tb
		# radioInfo				= getWItemRadioInfo itemH.wItemInfo
		  show					= showContext && itemH.wItemShow
		  able					= ableContext && itemH.wItemSelect
		# (radioItems,(_,tb))	= StateMap (createRadioItem show able (toTuple parentPos) wPtr radioInfo.radioIndex) radioInfo.radioItems (1,tb)
		  radioInfo				= {radioInfo & radioItems=radioItems}
		= ({itemH & wItemInfo=RadioInfo radioInfo},tb)
	where
		createRadioItem :: !Bool !Bool !(!Int,!Int) !OSWindowPtr !Index !(RadioItemInfo .ps) !(!Index,!*OSToolbox)
																 	 -> (!RadioItemInfo .ps, !(!Index,!*OSToolbox))
		createRadioItem show able parentPos wPtr index item=:{radioItem=(title,_),radioItemPos,radioItemSize} (itemNr,tb)
			# (radioPtr,tb)		= OScreateRadioControl wPtr parentPos title show able (toTuple radioItemPos) (toTuple radioItemSize) (index==itemNr) (itemNr==1) tb
			= ({item & radioItemPtr=radioPtr},(itemNr+1,tb))
	
	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsCheckControl} tb
		# checkInfo				= getWItemCheckInfo itemH.wItemInfo
		  show					= showContext && itemH.wItemShow
		  able					= ableContext && itemH.wItemSelect
		# (checkItems,(_,tb))	= StateMap (createCheckItem show able (toTuple parentPos) wPtr) checkInfo.checkItems (1,tb)
		  checkInfo				= {checkInfo & checkItems=checkItems}
		= ({itemH & wItemInfo=CheckInfo checkInfo},tb)
	where
		createCheckItem :: !Bool !Bool !(!Int,!Int) !OSWindowPtr !(CheckItemInfo .ps) !(!Index,!*OSToolbox)
															  -> (!CheckItemInfo .ps, !(!Index,!*OSToolbox))
		createCheckItem show able parentPos wPtr item=:{checkItem=(title,mark,_),checkItemPos,checkItemSize} (itemNr,tb)
			# (checkPtr,tb)		= OScreateCheckControl wPtr parentPos title show able (toTuple checkItemPos) (toTuple checkItemSize) (marked mark) (itemNr==1) tb
			= ({item & checkItemPtr=checkPtr},(itemNr+1,tb))
	
	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsPopUpControl} tb
		# (popUpPtr,tb)			= OScreateEmptyPopUpControl wPtr (toTuple parentPos) showContext ableContext (toTuple pos) (toTuple size) (length items) tb
		# (_,tb)				= StateMap2 (appendPopUp popUpPtr info.popUpInfoIndex) items (1,tb)
		= ({itemH & wItemPtr=popUpPtr},tb)
	where
		pos						= itemH.wItemPos
		size					= itemH.wItemSize
		info					= getWItemPopUpInfo itemH.wItemInfo
		items					= info.popUpInfoItems
		
		appendPopUp :: !OSWindowPtr !Index !(PopUpControlItem .ps) !(!Int,!*OSToolbox) -> (!Int,!*OSToolbox)
		appendPopUp popUpPtr index (title,_) (itemNr,tb)
			# (_,tb)			= OScreatePopUpControlItem popUpPtr ableContext title (index==itemNr) tb
			= (itemNr+1,tb)
	
	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsSliderControl} tb
		# (sliderPtr,tb)		= OScreateSliderControl wPtr (toTuple parentPos) show able (direction==Horizontal) (toTuple pos) (toTuple size) (osMin,osThumb,osMax,osThumbSize) tb
		= ({itemH & wItemPtr=sliderPtr},tb)
	where
		show					= showContext && itemH.wItemShow
		able					= ableContext && itemH.wItemSelect
		info					= getWItemSliderInfo itemH.wItemInfo
		direction				= info.sliderInfoDir
		sliderState				= info.sliderInfoState
		min						= sliderState.sliderMin
		max						= sliderState.sliderMax
		(osMin,osThumb,osMax,osThumbSize)
								= toOSscrollbarRange (min,sliderState.sliderThumb,max) 0
		pos						= itemH.wItemPos
		size					= itemH.wItemSize

	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsTextControl} tb
		# (textPtr,tb)			= OScreateTextControl wPtr (toTuple parentPos) title show (toTuple pos) (toTuple size) tb
		= ({itemH & wItemPtr=textPtr},tb)
	where
		show					= showContext && itemH.wItemShow
		pos						= itemH.wItemPos
		size					= itemH.wItemSize
		title					= (getWItemTextInfo itemH.wItemInfo).textInfoText
	
	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsEditControl} tb
		# (editPtr,tb)			= OScreateEditControl wPtr (toTuple parentPos) text show able keySensitive (toTuple pos) (toTuple size) tb
		= ({itemH & wItemPtr=editPtr},tb)
	where
		show					= showContext && itemH.wItemShow
		able					= ableContext && itemH.wItemSelect
		keySensitive			= Contains iscontrolkeyboard itemH.wItemAtts
		pos						= itemH.wItemPos
		size					= itemH.wItemSize
		text					= (getWItemEditInfo itemH.wItemInfo).editInfoText
	
	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsButtonControl} tb
		# (buttonPtr,tb)		= OScreateButtonControl wPtr (toTuple parentPos) title show able (toTuple pos) (toTuple size) isDefaultButton tb
		= ({itemH & wItemPtr=buttonPtr},tb)
	where
		show					= showContext && itemH.wItemShow
		able					= ableContext && itemH.wItemSelect
		pos						= itemH.wItemPos
		size					= itemH.wItemSize
		itemId					= itemH.wItemId
		isDefaultButton			= isJust defaultId && isJust itemId && fromJust defaultId==fromJust itemId
		title					= (getWItemButtonInfo itemH.wItemInfo).buttonInfoText
	
	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsCustomButtonControl} tb
		# (buttonPtr,tb)		= OScreateCustomButtonControl wPtr (toTuple parentPos) show able (toTuple pos) (toTuple size) isDefaultButton tb
		= ({itemH & wItemPtr=buttonPtr},tb)
	where
		show					= showContext && itemH.wItemShow
		able					= ableContext && itemH.wItemSelect
		pos						= itemH.wItemPos
		size					= itemH.wItemSize
		itemId					= itemH.wItemId
		isDefaultButton			= isJust defaultId && isJust itemId && fromJust defaultId==fromJust itemId
	
	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsCustomControl} tb
		# (customPtr,tb)		= OScreateCustomControl wPtr (toTuple parentPos) show able (toTuple pos) (toTuple size) tb
		= ({itemH & wItemPtr=customPtr},tb)
	where
		show					= showContext && itemH.wItemShow
		able					= ableContext && itemH.wItemSelect
		pos						= itemH.wItemPos
		size					= itemH.wItemSize
	
	createWItemHandle defaultId showContext ableContext parentPos wPtr itemH=:{wItemKind=IsCompoundControl} tb
		# (compoundPtr,hPtr,vPtr,tb)
								= OScreateCompoundControl wPtr (toTuple parentPos) show able (toTuple pos) (toTuple size) hScroll vScroll tb
		  compoundInfo			= {info & compoundHScroll=setScrollbarPtr hPtr info.compoundHScroll
		  								, compoundVScroll=setScrollbarPtr vPtr info.compoundVScroll
		  						  }
		# (itemHs,tb)			= StateMap (createWElementHandle defaultId show able itemH.wItemPos compoundPtr) itemH.wItems tb
		= ({itemH & wItemInfo=CompoundInfo compoundInfo,wItemPtr=compoundPtr,wItems=itemHs},tb)
	where
		show					= showContext && itemH.wItemShow
		able					= ableContext && itemH.wItemSelect
		pos						= itemH.wItemPos
		size					= itemH.wItemSize
		info					= getWItemCompoundInfo itemH.wItemInfo
		domain					= info.compoundDomain
		origin					= info.compoundOrigin
		hScroll
			| isJust info.compoundHScroll
			= {cbiHasScroll=True, cbiPos=toTuple hInfo.scrollItemPos,cbiSize=toTuple hSize,cbiState=hState}
			= {cbiHasScroll=False,cbiPos=undef,cbiSize=undef,cbiState=undef}
		where
			hInfo	= fromJust info.compoundHScroll
			hSize	= hInfo.scrollItemSize
			hState	= toOSscrollbarRange (domain.corner1.x,origin.x,domain.corner2.x) size.w
		vScroll
			| isJust info.compoundVScroll
			= {cbiHasScroll=True, cbiPos=toTuple vInfo.scrollItemPos,cbiSize=toTuple vSize,cbiState=vState}
			= {cbiHasScroll=False,cbiPos=undef,cbiSize=undef,cbiState=undef}
		where
			vInfo	= fromJust info.compoundVScroll
			vSize	= vInfo.scrollItemSize
			vState	= toOSscrollbarRange (domain.corner1.y,origin.y,domain.corner2.y) size.h
		
		setScrollbarPtr :: OSWindowPtr !(Maybe ScrollInfo) -> Maybe ScrollInfo
		setScrollbarPtr _ Nothing
			= Nothing
		setScrollbarPtr scrollPtr (Just info)
			= Just {info & scrollItemPtr=scrollPtr}

	createWItemHandle _ _ _ _ _ itemH tb
		= (itemH,tb)
